<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns="http://www.w3.org/TR/html4"
                              xmlns:html="http://www.w3.org/TR/html4"
                              xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                              xmlns:wwmode="urn:WebWorks-Engine-Mode"
                              xmlns:wwlinks="urn:WebWorks-Engine-Links-Schema"
                              xmlns:wwfiles="urn:WebWorks-Engine-Files-Schema"
                              xmlns:wwdoc="urn:WebWorks-Document-Schema"
                              xmlns:wwsplits="urn:WebWorks-Engine-Splits-Schema"
                              xmlns:wwtoc="urn:WebWorks-Engine-TOC-Schema"
                              xmlns:wwbehaviors="urn:WebWorks-Behaviors-Schema"
                              xmlns:wwvars="urn:WebWorks-Variables-Schema"
                              xmlns:wwnotes="urn:WebWorks-Footnote-Schema"
                              xmlns:wwproject="urn:WebWorks-Publish-Project"
                              xmlns:wwpage="urn:WebWorks-Page-Template-Schema"
                              xmlns:wwlocale="urn:WebWorks-Locale-Schema"
                              xmlns:wwprogress="urn:WebWorks-XSLT-Extension-Progress"
                              xmlns:wwlog="urn:WebWorks-XSLT-Extension-Log"
                              xmlns:wwfilesystem="urn:WebWorks-XSLT-Extension-FileSystem"
                              xmlns:wwuri="urn:WebWorks-XSLT-Extension-URI"
                              xmlns:wwstring="urn:WebWorks-XSLT-Extension-StringUtilities"
                              xmlns:wwunits="urn:WebWorks-XSLT-Extension-Units"
                              xmlns:wwfilesext="urn:WebWorks-XSLT-Extension-Files"
                              xmlns:wwprojext="urn:WebWorks-XSLT-Extension-Project"
                              xmlns:wwimaging="urn:WebWorks-XSLT-Extension-Imaging"
                              xmlns:wwexsldoc="urn:WebWorks-XSLT-Extension-Document"
                              exclude-result-prefixes="xsl msxsl wwmode wwlinks wwfiles wwdoc wwsplits wwtoc wwbehaviors wwvars wwnotes wwproject wwpage wwlocale wwprogress wwlog wwfilesystem wwuri wwstring wwunits wwfilesext wwprojext wwimaging wwexsldoc"
>
 <xsl:param name="GlobalInput" />
 <xsl:param name="GlobalPipelineName" />
 <xsl:param name="GlobalProject" />
 <xsl:param name="GlobalFiles" />
 <xsl:param name="ParameterLocaleType" />
 <xsl:param name="ParameterProjectVariablesType" />
 <xsl:param name="ParameterPageTemplateURI" />
 <xsl:param name="ParameterType" />
 <xsl:param name="ParameterCategory" />
 <xsl:param name="ParameterUse" />
 <xsl:param name="ParameterDeploy" />


 <xsl:output method="xml" encoding="UTF-8" indent="yes" />
 <xsl:namespace-alias stylesheet-prefix="html" result-prefix="#default" />
 <xsl:strip-space elements="*" />
 <xsl:preserve-space elements="html:script" />


 <xsl:key name="wwfiles-files-by-type" match="wwfiles:File" use="@type" />


 <xsl:include href="wwtransform:common/variables/variables.xsl" />
 <xsl:include href="wwtransform:common/pages/pagetemplate.xsl" />


 <xsl:variable name="GlobalActionChecksum">
  <xsl:variable name="VarTransformChecksums">
   <xsl:value-of select="concat(wwuri:AsFilePath('wwtransform:self'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:self')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath($ParameterPageTemplateURI), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath($ParameterPageTemplateURI)))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/variables/variables.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/variables/variables.xsl')))" />
   <xsl:value-of select="concat(',', wwuri:AsFilePath('wwtransform:common/pages/pagetemplate.xsl'), ':', wwfilesystem:GetChecksum(wwuri:AsFilePath('wwtransform:common/pages/pagetemplate.xsl')))" />
  </xsl:variable>
  <xsl:value-of select="wwstring:MD5Checksum($VarTransformChecksums)" />
 </xsl:variable>


 <!-- Locale -->
 <!--        -->
 <xsl:variable name="GlobalLocalePath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterLocaleType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalLocale" select="wwexsldoc:LoadXMLWithoutResolver($GlobalLocalePath)" />


 <!-- Mapping Entry Sets -->
 <!--                    -->
 <xsl:variable name="GlobalMapEntrySetsPath" select="wwuri:AsFilePath('wwtransform:html/mapentrysets.xml')" />
 <xsl:variable name="GlobalMapEntrySets" select="wwexsldoc:LoadXMLWithoutResolver($GlobalMapEntrySetsPath)" />


 <!-- Page Template -->
 <!--               -->
 <xsl:variable name="GlobalPageTemplatePath" select="wwuri:AsFilePath($ParameterPageTemplateURI)" />
 <xsl:variable name="GlobalPageTemplate" select="wwexsldoc:LoadXMLWithoutResolver($GlobalPageTemplatePath)" />


 <!-- Project variables -->
 <!--                   -->
 <xsl:variable name="GlobalProjectVariablesPath">
  <xsl:for-each select="$GlobalFiles[1]">
   <xsl:value-of select="key('wwfiles-files-by-type', $ParameterProjectVariablesType)[1]/@path" />
  </xsl:for-each>
 </xsl:variable>
 <xsl:variable name="GlobalProjectVariables" select="wwexsldoc:LoadXMLWithoutResolver($GlobalProjectVariablesPath)" />


 <xsl:template match="/">
  <wwfiles:Files version="1.0">

   <!-- Get page template files -->
   <!--                         -->
   <xsl:variable name="VarPageTemplateFilesAsXML">
    <xsl:apply-templates select="$GlobalPageTemplate" mode="wwmode:pagetemplate-files" />
   </xsl:variable>
   <xsl:variable name="VarPageTemplateFiles" select="msxsl:node-set($VarPageTemplateFilesAsXML)" />
   <xsl:variable name="VarPageTemplateFilesPaths">
    <xsl:for-each select="$VarPageTemplateFiles/wwpage:File">
     <xsl:value-of select="@path" />
     <xsl:value-of select="':'" />
    </xsl:for-each>
   </xsl:variable>
   <xsl:variable name="VarPageTemplateFilesChecksum" select="wwstring:MD5Checksum($VarPageTemplateFilesPaths)" />

   <!-- Determine number of groups and merge steps -->
   <!--                                            -->
   <xsl:variable name="VarProjectGroups" select="$GlobalProject/wwproject:Project/wwproject:Groups/wwproject:Group" />

   <xsl:variable name="VarGroupsCount" select="count($VarProjectGroups)" />
   <xsl:variable name="VarGroupsAndMergeCountAsString">
    <xsl:choose>
     <xsl:when test="$VarGroupsCount &gt; 1">
      <xsl:value-of select="$VarGroupsCount + 1" />
     </xsl:when>

     <xsl:otherwise>
      <xsl:value-of select="$VarGroupsCount" />
     </xsl:otherwise>
    </xsl:choose>
   </xsl:variable>
   <xsl:variable name="VarGroupsAndMergeCount" select="number($VarGroupsAndMergeCountAsString)" />

   <xsl:variable name="VarProgressProjectGroupsStart" select="wwprogress:Start($VarGroupsAndMergeCount)" />

   <!-- Groups -->
   <!--        -->
   <xsl:for-each select="$VarProjectGroups">
    <xsl:variable name="VarProjectGroup" select="." />

    <xsl:variable name="VarProgressProjectGroupStart" select="wwprogress:Start(1)" />

    <!-- Aborted? -->
    <!--          -->
    <xsl:if test="not(wwprogress:Abort())">
     <!-- Create splash page -->
     <!--                    -->
     <xsl:variable name="VarOutputDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), wwprojext:GetGroupName($VarProjectGroup/@GroupID), 'wwhelp', 'wwhimpl', 'common', 'html')" />
     <xsl:call-template name="Splash">
      <xsl:with-param name="ParamOutputDirectoryPath" select="$VarOutputDirectoryPath" />
      <xsl:with-param name="ParamPageTemplateFiles" select="$VarPageTemplateFiles" />
      <xsl:with-param name="ParamPageTemplateFilesChecksum" select="$VarPageTemplateFilesChecksum" />
      <xsl:with-param name="ParamVariables" select="$GlobalProjectVariables/wwvars:Variables/wwvars:Group[@groupID = $VarProjectGroup/@GroupID]//wwvars:Variable" />
     </xsl:call-template>
    </xsl:if>

    <xsl:variable name="VarProgressProjectGroupEnd" select="wwprogress:End()" />
   </xsl:for-each>

   <!-- Merge -->
   <!--       -->
   <xsl:if test="$VarGroupsCount &gt; 1">
    <xsl:variable name="VarProgressMergeStart" select="wwprogress:Start(1)" />

    <!-- Aborted? -->
    <!--          -->
    <xsl:if test="not(wwprogress:Abort())">
     <!-- Create splash page -->
     <!--                    -->
     <xsl:variable name="VarOutputDirectoryPath" select="wwfilesystem:Combine(wwprojext:GetTargetOutputDirectoryPath(), 'wwhelp', 'wwhimpl', 'common', 'html')" />
     <xsl:call-template name="Splash">
      <xsl:with-param name="ParamOutputDirectoryPath" select="$VarOutputDirectoryPath" />
      <xsl:with-param name="ParamPageTemplateFiles" select="$VarPageTemplateFiles" />
      <xsl:with-param name="ParamPageTemplateFilesChecksum" select="$VarPageTemplateFilesChecksum" />
      <xsl:with-param name="ParamVariables" select="$GlobalProjectVariables//wwvars:Variable" />
     </xsl:call-template>
    </xsl:if>

    <xsl:variable name="VarProgressMergeEnd" select="wwprogress:End()" />
   </xsl:if>

   <xsl:variable name="VarProgressProjectGroupsEnd" select="wwprogress:End()" />

  </wwfiles:Files>
 </xsl:template>


 <xsl:template name="Splash">
  <xsl:param name="ParamOutputDirectoryPath" />
  <xsl:param name="ParamPageTemplateFiles" />
  <xsl:param name="ParamPageTemplateFilesChecksum" />
  <xsl:param name="ParamVariables" />

  <!-- Output -->
  <!--        -->
  <xsl:variable name="VarPath" select="wwfilesystem:Combine($ParamOutputDirectoryPath, 'default.htm')" />
  <xsl:variable name="VarUpToDate" select="wwfilesext:UpToDate($VarPath, concat($GlobalProject/wwproject:Project/@ChangeID, ':', $ParamPageTemplateFilesChecksum), '', '', $GlobalActionChecksum)" />
  <xsl:if test="not($VarUpToDate)">
   <xsl:variable name="VarResultAsXML">
    <!-- Conditions -->
    <!--            -->
    <xsl:variable name="VarConditionsAsXML">
     <!-- wwhelp-show-<page> -->
     <!--                    -->
     <xsl:choose>
      <xsl:when test="wwprojext:GetFormatSetting('wwhelp-show-first-document') = 'true'">
       <wwpage:Condition name="wwhelp-show-first-document" />
      </xsl:when>

      <xsl:otherwise>
       <wwpage:Condition name="wwhelp-show-splash-page" />
      </xsl:otherwise>
     </xsl:choose>
    </xsl:variable>
    <xsl:variable name="VarConditions" select="msxsl:node-set($VarConditionsAsXML)" />

    <!-- Replacements -->
    <!--              -->
    <xsl:variable name="VarReplacementsAsXML">
     <!-- Locale -->
     <!--        -->
     <wwpage:Replacement name="locale" value="{wwprojext:GetFormatSetting('locale', 'en')}" />

     <!-- Content Type -->
     <!--              -->
     <wwpage:Replacement name="content-type" value="{concat('text/html;charset=', wwprojext:GetFormatSetting('encoding', 'utf-8'))}" />

     <!-- wwhelp-onload -->
     <!--               -->
     <wwpage:Replacement name="wwhelp-onload">
      <xsl:choose>
       <xsl:when test="wwprojext:GetFormatSetting('wwhelp-show-first-document') = 'true'">
        <xsl:text>WWHOnLoad(true);</xsl:text>
       </xsl:when>

       <xsl:otherwise>
        <xsl:text>WWHOnLoad(false);</xsl:text>
       </xsl:otherwise>
      </xsl:choose>
     </wwpage:Replacement>

     <!-- Variables -->
     <!--           -->
     <xsl:variable name="VarVariablesAsXML">
      <xsl:call-template name="Variables-Filter-Last-Unique">
       <xsl:with-param name="ParamVariables" select="$ParamVariables" />
      </xsl:call-template>
     </xsl:variable>
     <xsl:variable name="VarVariables" select="msxsl:node-set($VarVariablesAsXML)/wwvars:Variable" />
     <xsl:call-template name="Variables-Page-String-Replacements">
      <xsl:with-param name="ParamVariables" select="$VarVariables" />
     </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="VarReplacements" select="msxsl:node-set($VarReplacementsAsXML)" />

    <!-- Map common characters -->
    <!--                       -->
    <wwexsldoc:MappingContext>
     <xsl:copy-of select="$GlobalMapEntrySets/wwexsldoc:MapEntrySets/wwexsldoc:MapEntrySet[@name = 'common']/wwexsldoc:MapEntry" />

     <!-- Invoke page template -->
     <!--                      -->
     <xsl:apply-templates select="$GlobalPageTemplate" mode="wwmode:pagetemplate">
      <xsl:with-param name="ParamOutputDirectoryPath" select="$ParamOutputDirectoryPath" />
      <xsl:with-param name="ParamOutputPath" select="$VarPath" />
      <xsl:with-param name="ParamConditions" select="$VarConditions" />
      <xsl:with-param name="ParamReplacements" select="$VarReplacements" />
     </xsl:apply-templates>
    </wwexsldoc:MappingContext>
   </xsl:variable>
   <xsl:variable name="VarResult" select="msxsl:node-set($VarResultAsXML)" />

   <!-- Aborted? -->
   <!--          -->
   <xsl:if test="not(wwprogress:Abort())">
    <xsl:variable name="VarWriteResult" select="wwexsldoc:Document($VarResult, $VarPath, 'utf-8', 'html', '4.0', 'yes', 'no', 'no', '-//W3C//DTD HTML 4.0//EN', 'http://www.w3.org/TR/REC-html40/strict.dtd')" />
   </xsl:if>
  </xsl:if>

  <!-- Aborted? -->
  <!--          -->
  <xsl:if test="not(wwprogress:Abort())">
   <!-- Record files -->
   <!--              -->
   <wwfiles:File path="{$VarPath}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarPath)}" projectchecksum="{concat($GlobalProject/wwproject:Project/@ChangeID, ':', $ParamPageTemplateFilesChecksum)}" groupID="" documentID="" actionchecksum="{$GlobalActionChecksum}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
    <wwfiles:Depends path="{$GlobalLocalePath}" checksum="{wwfilesystem:GetChecksum($GlobalLocalePath)}" groupID="" documentID="" />
    <wwfiles:Depends path="{$GlobalMapEntrySetsPath}" checksum="{wwfilesystem:GetChecksum($GlobalMapEntrySetsPath)}" groupID="" documentID="" />
    <wwfiles:Depends path="{$GlobalPageTemplatePath}" checksum="{wwfilesystem:GetChecksum($GlobalPageTemplatePath)}" groupID="" documentID="" />
    <wwfiles:Depends path="{$GlobalProjectVariablesPath}" checksum="{wwfilesystem:GetChecksum($GlobalProjectVariablesPath)}" groupID="" documentID="" />
   </wwfiles:File>
  </xsl:if>

  <!-- Page Template Files -->
  <!--                     -->
  <xsl:for-each select="$ParamPageTemplateFiles/wwpage:File">
   <xsl:variable name="VarPageTemplateFile" select="." />

   <!-- Get source and destination paths -->
   <!--                                  -->
   <xsl:variable name="VarSourcePath" select="wwuri:AsFilePath(concat('wwformat:Pages/', $VarPageTemplateFile/@path))" />
   <xsl:variable name="VarDestinationPath" select="wwfilesystem:Combine($ParamOutputDirectoryPath, $VarPageTemplateFile/@path)" />
   
   <!-- Copy -->
   <!--      -->
   <xsl:variable name="VarPageTemplateFileUpToDate" select="wwfilesext:UpToDate($VarDestinationPath, '', '', '', concat($GlobalActionChecksum, ':', $VarSourcePath))" />
   <xsl:if test="not($VarPageTemplateFileUpToDate)">
    <xsl:variable name="VarIgnore" select="wwfilesystem:CopyFile($VarSourcePath, $VarDestinationPath)" />
   </xsl:if>

   <!-- Report Files -->
   <!--              -->
   <wwfiles:File path="{$VarDestinationPath}" type="{$ParameterType}" checksum="{wwfilesystem:GetChecksum($VarDestinationPath)}" projectchecksum="" groupID="" documentID="" actionchecksum="{concat($GlobalActionChecksum, ':', $VarSourcePath)}" category="{$ParameterCategory}" use="{$ParameterUse}" deploy="{$ParameterDeploy}">
    <wwfiles:Depends path="{$VarSourcePath}" checksum="{wwfilesystem:GetChecksum($VarSourcePath)}" groupID="" documentID="" />
   </wwfiles:File>
  </xsl:for-each>
 </xsl:template>
</xsl:stylesheet>
